<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Http\Requests\RegisterUserRequest;
use Validator;
use Auth;
use Mail;
use DB;
class AuthController extends Controller
{
    public function register(Request $request)
    {
    	try
    	{    
    		$user = new User();
    		$data = $user->registerUser($request); 
    		return response()->json($data);
    	}catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function login(Request $request)
    {
    	try
    	{
    	    $user = new User();
    		$data = $user->loginUser($request); 
    		return response()->json($data);
    	}catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function logout(Request $request)
    {
    	try
    	{
    		$user = new User();
    		$data = $user->logoutUser($request);
    		return response()->json($data);
    	}catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
  

  public function delivermenRegister(Request $request) 
  {
      try
      {   

          $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|string|unique:users',
            'phone' => 'required|string|unique:users',
            'address' => 'required',
            'password' => 'required',
        ]);

        if($validator->fails()){
            return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
        }

          if($request->image)
          {   
            $file = $request->file('image');
            $name = time().$file->getClientOriginalName();
            $file->move(public_path().'/uploads/users/', $name); 
            $path = 'public/uploads/users/'.$name;
          }
          else
          {
              $path = NULL;
          }

          $user  = new User();
          $user->name = $request->name;
          $user->role = 'delivery_men';
          $user->email = $request->email;
          $user->phone = $request->phone;
          $user->gender = $request->gender;
          $user->dob = $request->dob;
          $user->division_id = $request->division_id;
          $user->district_id = $request->district_id;
          $user->device_token = $request->device_token;
          $user->city_id = $request->city_id;
          $user->identity_name = $request->identity_name;
          $user->identity_info = $request->identity_info;
          $user->referral_code = $request->referral_code; 
          $user->address = $request->address;
          $user->image = $path;
          $user->domain = url('/');
          $user->status = 'Active';
          $user->password = bcrypt($request->password);
          $user->save();

          $odata = array();
          $odata['user_id'] = $user->id;
          $odata['type'] = $request->type;
          $odata['brand']  = $request->brand;
          $odata['model'] = $request->model;
          $odata['reg_no'] = $request->reg_no;
          $odata['year'] = $request->year;
          $odata['tax_token_no'] = $request->tax_token_no;
          $odata['fitness_number'] = $request->fitness_number;
           
           DB::table('deliveryvehicles')->insert($odata);

          $otp = rand(1231,7879);

        $values = array(); 
        $values['user_id'] = $user->id;
        $values['otp'] = $otp;
        DB::table('otps')->insert($values);

        $mail_data = array('name'=>"OTP", "to_address"=>$request->email, 'subject'=>'OTP', 'body'=>$otp, 'title'=>'OTP', 'from_address'=>env('MAIL_USERNAME')); 
                  Mail::send('otp', $mail_data, function($message) use ($mail_data) {
                     $message->to($mail_data['to_address'], '')->subject
                        ($mail_data['subject']);
                     $message->from($mail_data['from_address'],'');
                  });

          DB::table('deliveryvehicles')->insert($odata);

          $data = ['id'=>$user->id, 'name'=>$request->name, 'email'=>$request->email, 'phone'=>$request->phone, 'address'=>"", 'domain'=>$user->domain, 'image'=>url('/')."/".$user->image];

         return response()->json(['status'=>true, 'message'=>'Please check your email inbox or spam to get otp', 'data'=>$data]);

      }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
  }
    

    public function setDeliverXone(Request $request)
    {
        try
        {   

            $validator = Validator::make($request->all(), [
                'lat' => 'required',
                'lon' => 'required',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }

            User::where('id',Auth::user()->id)->update(['lat'=>$request->lat, 'lon'=>$request->lon]);
            return response()->json(['status'=>true, 'message'=>'Successfully latitude and lontitute has been taken']);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

 

    public function deliverymenLogin(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [

                    'email' => 'required|email',
                    'password' => 'required',
                ]);
       
            if($validator->fails()){
              return ['message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }


            $get_user = DB::table('users')->where('email',$request->email)->first();

            if($get_user->role != 'delivery_men')
            {
                return ['status'=>false, 'message'=>'Sorry you are not deliverymen', 'data'=>['token'=>"", 'id'=>0, 'name'=>"", "email"=>"", 'phone'=>"", "address"=>"", 'domain'=>"", 'image'=>null]];
            }

            if($get_user->status == 'Pending')
            { 
                  return ['status'=>false, 'message'=>'Sorry you are not verified or declined by admin', 'data'=>['token'=>"", 'id'=>0, 'name'=>"", "email"=>"", 'phone'=>"", "address"=>"", 'domain'=>"", 'image'=>null]];
            }

            if(Auth::attempt(['email' => $request->email, 'password' => $request->password])){ 
                $user = Auth::user(); 
                if($user->image == NULL)
                {
                    $image = NULL;
                }
                else
                {
                    $image = url('/')."/".$user->image;
                }

                $data['token'] =  $user->createToken('MyApp')->plainTextToken; 
                $data['id'] = $user->id;
                $data['name'] =  $user->name;
                $data['email'] = $user->email;
                $data['phone'] = $user->phone;
                $data['address'] = "";
                $data['image'] = $image;
                $data['domain'] = $user->domain;
                return ['status'=>true, 'message'=>'User login successfully', 'data'=>$data];
            } 
            else{ 
                return ['status'=>false, 'message'=>'Unauthorized', 'data'=>['token'=>"", 'id'=>0, 'name'=>"", "email"=>"", 'phone'=>"", "address"=>"", 'domain'=>"", 'image'=>null]];
            } 
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function deliverymenDetails()
    {
        try
        {
                $user = Auth::user();
                
               $total_delivery = DB::table('orders')->where('user_id',Auth::user()->id)->count();
               
               
                
                $total_review = DB::table('reviews')->where('deliverymen_id',$user->id)->where('review_taker', 'user')->sum('total_star');
                
               
                
                $count_review = DB::table('reviews')->where('deliverymen_id',$user->id)->where('review_taker', 'user')->count();
                
                if($count_review == 0 || $total_review == 0)
                {
                    $review = "0";
                }
                else
                {
                    $review = number_format($total_review/$count_review, 1);
                }
                
               
               
                $data['id'] = $user->id;
                $data['address'] = $user->address;
                $data['name'] =  $user->name;
                $data['email'] = $user->email;
                $data['phone'] = $user->phone;
                $data['balance'] = $user->balance;
                $data['image'] = url('/')."/".$user->image;
                $data['total_delivery'] = $total_delivery;
                $data['duration'] = intval(durationMonth($user->id)); 
                $data['review'] = $review;
                return response()->json(['status'=>true, 'data'=>$data]);
          
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
}
