<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CityCorporation;
use App\Models\District;
use Auth;
use DB;
use App\Models\Order;
use App\Models\Withdrawrequest;

class AjaxController extends Controller
{
    public function getCity($id)
    {
    	try
    	{
    	   $cities = CityCorporation::where('division_id',$id)->where('country',Auth::user()->country)->get();
    	   return view('ajax.cities', compact('cities'));
    	}catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function getDistrict($id)
    {
    	try
    	{
    		$districts = District::where('division_id',$id)->get();
    	   return view('ajax.districts', compact('districts'));
    	}catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function getThanas(Request $request)
    {
        try
        {
            $query = DB::table('thanas');
             if($request->division_id != null){
                 $query->where('division_id', $request->division_id);
              }

              if($request->district_id != null){
                 $query->where('district_id', $request->district_id);
              }

              $get_thanas = $query->groupBy('thana')->get();

              
              $thanas = array();

              foreach($get_thanas as $thana)
              {
                  $countCity = DB::table('cities')->where('thana_id',$thana->id)->count();
                   if($countCity > 0)
                    {
                        $is_checked = 1;
                    }
                    else
                    {
                        $is_checked = 0;
                    }
                  
                  $thanas[] = ['id'=>$thana->id, 'name'=>$thana->thana,'is_checked'=>$is_checked];

              }

            return view('settings.get_thana', compact('thanas')); 

        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function getOrder($id)
    {
        try
        {
            $order = Order::join('users as senders' , 'orders.sender_id', 'senders.id')
                            ->join('users as delivers', 'orders.user_id', 'delivers.id')
                            ->select('orders.*', 'senders.name as sender_name', 'senders.phone as sender_phone', 'senders.address as sender_address', 'delivers.name as deliver_name', 'delivers.phone as deliver_phone', 'delivers.address as delivery_address')
                            ->where('orders.id',$id)
                            ->first();
                            
            $another_order = Order::join('users as senders' , 'orders.sender_id', 'senders.id')
                            ->select('orders.*', 'senders.name as sender_name', 'senders.phone as sender_phone', 'senders.address as sender_address')
                            ->where('orders.id',$id)
                            ->first();
                            
            if(!$order)
            {
                return response()->json($another_order);
            }
            else
            {
                return response()->json($order);
            }
            
            
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    
    public function updateChangeStatus(Request $request, $id)
    {
        try
        {
            DB::table('orders')->where('id',$id)->update(['status'=>$request->status]);
            return response()->json('Successfully status has been changed');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function declineWithdraw($id)
    {
        try
        {
            $withdraw = Withdrawrequest::findorfail($id);
            $withdraw->status = 'Pending';
            $withdraw->update();
            return response()->json('Successfully Declined');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function activeWithdraw($id)
    {
        try
        {
            $withdraw = Withdrawrequest::findorfail($id);
            $withdraw->status = 'Approved';
            $withdraw->update();
            return response()->json('Successfully Approved');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    

}
