<?php

namespace App\Http\Controllers;

use App\Models\Inbox;
use Illuminate\Http\Request;
use App\Http\Requests\StoreNotidficationRequest;
use App\Http\Requests\UpdateNotificationRequest;
use DataTables;
class InboxController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth_check');
    }
    public function index(Request $request)
    {
        try
        {
           if($request->ajax()) {
                $data = Inbox::orderBy('id', 'DESC')->select('*');

                return Datatables::of($data)
                        ->addIndexColumn()
                       
                        ->addColumn('action', function($row){
                                                        
                           $btn = "";
                            $btn .= '&nbsp;';
                            $btn .= ' <a href="'.route('inboxes.show',$row->id).'" class="btn btn-primary btn-sm action-button"><i class="fa fa-edit"></i></a>';

                            $btn .= '&nbsp;';


                              $btn .= ' <a href="#" class="btn btn-danger btn-sm delete-notification action-button" data-id="'.$row->id.'"><i class="fa fa-trash"></i></a>'; 
        
                          
        
                                return $btn;
                        })
                        ->rawColumns(['action'])
                        ->make(true); 
            }
            return view('notifications.index');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        } 
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try
        {
            return view('notifications.create');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreNotidficationRequest $request)
    {
        try
        {  
            if($request->file('image'))
            {    
                $image = $request->file('image');
                $name = time().$image->getClientOriginalName();
                $image->move(public_path().'/uploads/inboxes/', $name); 
                $path = 'uploads/inboxes/'.$name;
            }
            $inbox = new Inbox();
            $inbox->title = $request->title;
            $inbox->type = $request->type;
            $inbox->description = strip_tags($request->description);
            $inbox->date = date('Y-m-d');
            $inbox->date_two = date('d F Y');
            $inbox->image = $path;
            $inbox->save();

            $notification=array(
                             'messege'=>"Successfully notification has been added",
                             'alert-type'=>'success'
                            );

            return Redirect()->back()->with($notification); 


        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Inbox  $inbox
     * @return \Illuminate\Http\Response
     */
    public function show(Inbox $inbox)
    {
        try
        {
           return view('notifications.edit', compact('inbox')); 
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Inbox  $inbox
     * @return \Illuminate\Http\Response
     */
    public function edit(Inbox $inbox)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Inbox  $inbox
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateNotificationRequest $request, Inbox $inbox)
    {
        try
        {   


            if($request->file('image'))
            {    
                $image = $request->file('image');
                $name = time().$image->getClientOriginalName();
                $image->move(public_path().'/uploads/inboxes/', $name); 
                unlink(public_path($inbox->image));
                $path = 'uploads/inboxes/'.$name;
            }
            else
            {
                $path = $inbox->image;
            }
            
            $inbox->title = $request->title;
            $inbox->type = $request->type;
            $inbox->description = strip_tags($request->description);
            $inbox->date = $inbox->date;
            $inbox->date_two = $inbox->date_two;
            $inbox->image = $path;
            $inbox->update();

            $notification=array(
                             'messege'=>"Successfully notification has been updated",
                             'alert-type'=>'success'
                            );

            return redirect('/inboxes')->with($notification); 
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Inbox  $inbox
     * @return \Illuminate\Http\Response
     */
    public function destroy(Inbox $inbox)
    {
        try
        {   
            unlink(public_path($inbox->image));
            $inbox->delete();  
            return response()->json('Successfully notification has been deleted');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
}
