<?php

namespace App\Http\Controllers;

use App\Models\PromoCode;
use Illuminate\Http\Request;
use App\Http\Requests\StorePromoCodeRequest;
use App\Http\Requests\UpdatePromoCodeRequest;
use DataTables;
class PromoCodeController extends Controller
{   

     public function __construct()
    {
        $this->middleware('auth_check');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try
        {
           if($request->ajax()) {
                $data = PromoCode::orderBy('id', 'DESC')->select('*');

                return Datatables::of($data)
                        ->addIndexColumn()
                       
                        ->addColumn('action', function($row){
                                                        
                           $btn = "";
                            $btn .= '&nbsp;';
                            $btn .= ' <a href="'.route('promocodes.show',$row->id).'" class="btn btn-primary btn-sm action-button"><i class="fa fa-edit"></i></a>';

                            $btn .= '&nbsp;';


                              $btn .= ' <a href="#" class="btn btn-danger btn-sm delete-promocode action-button" data-id="'.$row->id.'"><i class="fa fa-trash"></i></a>'; 
        
                          
        
                                return $btn;
                        })
                        ->rawColumns(['action'])
                        ->make(true); 
            }
            return view('promocodes.index'); 
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }  
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('promocodes.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StorePromoCodeRequest $request)
    {
        try
        {
            if($request->file('image'))
            {    
                $image = $request->file('image');
                $name = time().$image->getClientOriginalName();
                $image->move(public_path().'/uploads/promocodes/', $name); 
                $path = 'uploads/promocodes/'.$name;
            }

            $promocode = new PromoCode();
            $promocode->title = $request->title;
            $promocode->from_date = $request->from_date;
            $promocode->to_date = $request->to_date;
            $promocode->discount = $request->discount;
            $promocode->image = $path;
            $promocode->save();

            $notification=array(
                             'messege'=>'Successfully promocode has been added',
                             'alert-type'=>'success'
                            );

            return Redirect()->back()->with($notification);

        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        } 
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\PromoCode  $promoCode
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try
        {  
            $promoCode = Promocode::findorfail($id);
            return view('promocodes.edit', compact('promoCode'));
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\PromoCode  $promoCode
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PromoCode  $promoCode
     * @return \Illuminate\Http\Response
     */
    public function update(UpdatePromoCodeRequest $request, $id)
    {
        try 
        {   
             $promoCode = Promocode::findorfail($id);
            if($request->file('image'))
            {    
                $image = $request->file('image');
                $name = time().$image->getClientOriginalName();
                $image->move(public_path().'/uploads/promocodes/', $name); 
                unlink(public_path($promoCode->image));
                $path = 'uploads/promocodes/'.$name;
            }
            else
            {
                $path = $promoCode->image;
            }

            $promoCode->title = $request->title;
            $promoCode->from_date = $request->from_date;
            $promoCode->to_date = $request->to_date;
            $promoCode->discount = $request->discount;
            $promoCode->image = $path;
            $promoCode->update();

            $notification=array(
                             'messege'=>'Successfully promocode has been updated',
                             'alert-type'=>'success'
                            );

            return redirect('/promocodes')->with($notification);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PromoCode  $promoCode
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try
        {   
             $promoCode = Promocode::findorfail($id);
            unlink(public_path($promoCode->image));
            $promoCode->delete();
            return response()->json('Successfully promocode has been deleted');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
}
