<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Validator;
use Illuminate\Http\Request;
use Auth;
use App\Http\Requests\RegisterUserRequest;
use Session;
use DB;
use Illuminate\Support\Facades\Hash;
use DataTables;
use App\Facades\MailClass;
use Mail;
class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];


    public function registerUser(Request $request)
    {   
        DB::beginTransaction();
        try
        {
            $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|email|unique:users',
            'phone' => 'required|string|unique:users',
            'address' => 'required',
            'password' => 'required',
            'confirm_password' => 'required|same:password',
        ]);

        if($validator->fails()){
            return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
        }
        
        if($request->image)
        {   
            $file = $request->file('image');
            $name = time().$file->getClientOriginalName();
            $file->move(public_path().'/uploads/users/', $name); 
            $path = 'public/uploads/users/'.$name;
        }
        else
        {
            $path = NULL;
        }
        $user = new Self();
        $user->role = 'user';
        $user->name = $request->name;
        $user->email = $request->email;
        $user->phone = $request->phone;
        $user->address = $request->address;
        $user->password = bcrypt($request->password);
        $user->domain = env('APP_URL');
        $user->status = 'Pending';
        $user->image = $path;
        $user->save();
        
        $data = array();

        $data['id'] = $user->id;
        $data['name'] = $user->name;
        $data['email'] = $user->email;
        $data['phone'] = $user->phone;
        $data['address'] = $user->address;
        $data['domain'] = $user->domain;
        if($path == NULL)
        {
            $data['image'] = $path;

        }
        else
        {
            $data['image'] = url('/')."/".$user->image;
        }
        // MailClass::forgotMail($request->all());

       $otp = rand(1231,7879);

        $values = array(); 
        $values['user_id'] = $user->id;
        $values['otp'] = $otp;

        DB::table('otps')->insert($values);

        $mail = mailData();

        if($mail->email != NULL && $mail->mail_host != NULL && $mail->mail_port != NULL && $mail->mail_encryption != NULL && $mail->password)
        {
            $mail_data = array('name'=>"OTP", "to_address"=>$request->email, 'subject'=>'OTP', 'body'=>$otp, 'title'=>'OTP', 'from_address'=>env('MAIL_USERNAME')); 
        
              Mail::send('otp', $mail_data, function($message) use ($mail_data) {
                 $message->to($mail_data['to_address'], '')->subject
                    ($mail_data['subject']);
                 $message->from($mail_data['from_address'],'');
              });
        }

        


        DB::commit();

        return ['status'=>true, 'message'=>'Please check your email inbox or spam to get otp', 'data'=>$data];
        }catch(Exception $e){
            DB::rollback();
            return response()->json(['status'=>false, 'code'=>$e->getCode(), 'message'=>$e->getMessage()],500);
        }
    }

    public function loginUser(Request $request)
    {
            $validator = Validator::make($request->all(), [

                    'email' => 'required|email',
                    'password' => 'required',
                ]);
       
            if($validator->fails()){
              return ['message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }


            $get_user = DB::table('users')->where('email',$request->email)->first();
            
            if($get_user)
            {
                if($get_user->status == 'Pending')
                { 
                      return ['status'=>false, 'message'=>'Sorry you are not verified', 'data'=>['token'=>"", 'id'=>0, 'name'=>"", "email"=>"", 'phone'=>"", "address"=>"", 'domain'=>"", 'image'=>null]];
                }
            }

            

            if(Auth::attempt(['email' => $request->email, 'password' => $request->password])){ 
                $user = Auth::user(); 
                if($user->image == NULL)
                {
                    $image = NULL;
                }
                else
                {
                    $image = url('/')."/".$user->image;
                }

                $data['token'] =  $user->createToken('MyApp')->plainTextToken; 
                $data['id'] = $user->id;
                $data['name'] =  $user->name;
                $data['email'] = $user->email;
                $data['phone'] = $user->phone;
                $data['address'] = $user->address;
                $data['image'] = $image;
                $data['domain'] = $user->domain;
                return ['status'=>true, 'message'=>'User login successfully', 'data'=>$data];
            } 
            else{ 
                return ['status'=>false, 'message'=>'Unauthorized', 'data'=>['token'=>"", 'id'=>0, 'name'=>"", "email"=>"", 'phone'=>"", "address"=>"", 'domain'=>"", 'image'=>null]];
            } 
    }

    public function logoutUser(Request $request)
    {
        auth()->user()->tokens()->delete();
        $data = array('status'=>true, 'message'=>'successfully logged out!');
        return $data; 
    }

    public function storeVendor($request)
    {    
         if($request->file('image'))
         {
            $image = $request->file('image');
            $name = time().$image->getClientOriginalName();
            $image->move(public_path().'/uploads/vendors/', $name); 
            $path = 'public/uploads/vendors/'.$name;
        }
        else
        {
            $path = NULL;
        }

         $user = new Self();
         $user->name = $request->name;
         $user->role = 'vendor';
         $user->password = bcrypt('12345');
         $user->email = $request->email;
         $user->phone = $request->phone;
         $user->division_id = $request->division_id;
         $user->district_id = $request->district_id;
         $user->postal_code = $request->postal_code;
         $user->city_id = $request->city_id;
         $user->lat = $request->lat;
         $user->lon = $request->lon;
         $user->address = $request->address;
         $user->image = $path;

         $user->save();

         $message = "Successfully a vendor has been added";
         //Session::put('message', $message);
         return $message;
    }
    public function vendors($request)
    {
          //
              
    }

    public function declineVendor($id)
    {
        User::where('id',$id)->update(['status'=>'Decline']);
        $message = "Successfully the vendor has been declined";
         Session::put('message', $message);
         return $message;
    }

    public function activeVendor($id)
    {
        User::where('id',$id)->update(['status'=>'Active']);
        $message = "Successfully the vendor has been acived";
         Session::put('message', $message);
         return $message;
    }

    public function updateUser(Request $request,$user)
    {
        if($request->file('image'))
         {
            $image = $request->file('image');
            $name = time().$image->getClientOriginalName();
            $image->move(public_path().'/uploads/vendors/', $name); 
            $path = 'public/uploads/vendors/'.$name;
            if($user->image != NULL)
            {
                unlink($user->image);
            }
        }
        else
        {
            $path = $user->image;
        }


         $user->name = $request->name;
         $user->role = 'vendor';
         $user->password = bcrypt('12345');
         $user->email = $request->email;
         $user->phone = $request->phone;
         $user->division_id = $request->division_id;
         $user->district_id = $request->district_id;
         $user->postal_code = $request->postal_code;
         $user->city_id = $request->city_id;
         $user->lat = $request->lat;
         $user->lon = $request->lon;
         $user->address = $request->address;
         $user->image = $path;
         $user->update();

         $message = "Successfully the vendor has been updated";
         Session::put('message', $message);
         return $message;

    }

    public function deleteVendor($user)
    {
        if($user->image != NULL)
        {
            unlink($user->image);
        }
        $user->delete();
        $message = "Successfully the vendor has been deleted";
         Session::put('message', $message);
         return $message;
    }


}
