<?php

namespace App\Observers;

use App\Models\Division;
use App\Models\District;
use App\Models\Thana;

class DivisionObserver
{
    /**
     * Handle the Division "created" event.
     *
     * @param  \App\Models\Division  $division
     * @return void
     */
    public function created(Division $division)
    {
        //
    }

    /**
     * Handle the Division "updated" event.
     *
     * @param  \App\Models\Division  $division
     * @return void
     */
    public function updated(Division $division)
    {
        //
    }

    /**
     * Handle the Division "deleted" event.
     *
     * @param  \App\Models\Division  $division
     * @return void
     */
    public function deleted(Division $division)
    {
        $districts = District::where('division_id', $division->id)->get();

        $thanas = Thana::where('division_id', $division->id)->get();

        if(count($districts) > 0)
        {
            District::where('division_id', $division->id)->delete();
        }

        if(count($thanas) > 0)
        {
            Thana::where('division_id', $division->id)->delete();
        }
    }

    /**
     * Handle the Division "restored" event.
     *
     * @param  \App\Models\Division  $division
     * @return void
     */
    public function restored(Division $division)
    {
        //
    }

    /**
     * Handle the Division "force deleted" event.
     *
     * @param  \App\Models\Division  $division
     * @return void
     */
    public function forceDeleted(Division $division)
    {
        //
    }
}
