$(document).ready(function(){

	$.ajaxSetup({
      headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
       }
   });

	$('.select2').select2()

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    }) 

   
    var base_url = localStorage.getItem('base_url');


     var ajax_url = '';



     var table = $('#payment-table').DataTable({
        searching: true,
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/payment-settings",
        },

        columns: [
            {data: 'name', name: 'name'},
            {data: 'status', name: 'status'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });

  

  var divisionTable = $('#division_table').DataTable({

        searching: true,                                      
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/divisions",
        
       
        },

        columns: [
            {data: 'name', name: 'name'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });

  var sliderTable = $('#slider_table').DataTable({

        searching: false,                                      
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/sliders",
        
       
        },

        columns: [
            {data: 'image', name: 'image'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });

  var notificationTable = $('#notification_table').DataTable({

        searching: true,                                      
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/inboxes",
        
       
        },

        columns: [
            {data: 'title', name: 'title'},
            {data: 'type', name: 'type'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });



  var promocodeTable = $('#promocode_table').DataTable({

        searching: true,                                      
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/promocodes",
        
       
        },

        columns: [
            {data: 'title', name: 'title'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });


  var vehicleTypes = $('#vehicle_types').DataTable({

        searching: true,                                      
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/vehicle-types",
        
       
        },

        columns: [
            {data: 'type', name: 'type'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });

  var brands = $('#brands').DataTable({

        searching: true,                                      
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/brands",
        
       
        },

        columns: [
            {data: 'brand', name: 'brand'},
            {data: 'type', name: 'type'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });


  var districtTable = $('#district_table').DataTable({

        searching: true,                                      
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/districts",
          data: function (d) {
                d.division_id = $('#filter-district-division').val(),
                d.search = $('.dataTables_filter input').val()
            } 
        
        },

        columns: [
            {data: 'name', name: 'name'},
            {data: 'division', name: 'division'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });

  $('#filter-district-division').change(function(){

        districtTable.draw(); 
    });


  var thanaTable = $('#thana_table').DataTable({

        searching: true,                                      
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/thanas",
          data: function (d) {
                d.division_id = $('#filter-thana-division-id').val(),
                d.district_id = $('#filter-thana-district-id').val(),
                d.search = $('.dataTables_filter input').val()
            } 
        
        },

        columns: [
            {data: 'thana', name: 'thana'},
            {data: 'district', name: 'district'},   
            {data: 'division', name: 'division'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });

  $('.filter-district-button').click(function(){

        thanaTable.draw(); 
    });

   
   var vendorTable = $('#vendor_table').DataTable({

        searching: true,                                      
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/users",
          data: function (d) {
                d.status = $('#filter-vendor-status').val(),
                d.search = $('.dataTables_filter input').val()
            }
       
        },

        columns: [
            {data: 'name', name: 'name'},
            {data: 'email', name: 'email'},
            {data: 'phone', name: 'phone'},
            {data: 'status', name: 'status'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });


   $('#filter-vendor-status').change(function(){

        vendorTable.draw(); 
    });


   var customReportTable = $('#custom-report').DataTable({ 
        searching: true,
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/custom-report",
          data: function (d) {
                 d.status = $('#filter-custom-status').val(),
                d.search = $('.dataTables_filter input').val(),
                d.select_section = $('#select-custom-section').val()
            }
        },

        columns: [
            {data: 'id', name: 'id'},
            {data: 'customer_name', name: 'customer_name'},
            {data: 'customer_phone', name: 'customer_phone'},
            {data: 'payment_method', name: 'payment_method'},
            {data: 'date', name: 'date'},
            {data: 'status', name: 'status'}, 
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
    

    $('.filter-custom-order').click(function(){
        customReportTable.draw();
    });


    var withdrawTable = $('#withdraw-report').DataTable({ 
        searching: false,
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/withdraw-report",
          data: function (d) {
                 d.status = $('#filter-withdraw-status').val(),
                d.select_section = $('#select-withdraw-section').val()
            }
        },

        columns: [
            {data: 'deliverymen', name: 'deliverymen'},
            {data: 'bank_name', name: 'bank_name'},
            {data: 'account_number', name: 'account_number'},
            {data: 'date', name: 'date'},
            {data: 'status', name: 'status'}, 
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
    

    $('.filter-withdraw-report').click(function(){
        withdrawTable.draw();
    });

   
   var monthlyYearlyTable = $('#monthly-yearly').DataTable({ 
        searching: true, 
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/monthly-yearly-report",
          data: function (d) {
                d.status = $('#filter-my-status').val(),
                d.search = $('.dataTables_filter input').val(),
                d.select_month = $('#select-my-month').val(),
                d.select_year = $('#select-my-year').val()
            }
        },

        columns: [
            {data: 'id', name: 'id'},
            {data: 'customer_name', name: 'customer_name'},
            {data: 'customer_phone', name: 'customer_phone'},
            {data: 'payment_method', name: 'payment_method'},
            {data: 'date', name: 'date'},
            {data: 'status', name: 'status'}, 
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
    

    $('.filter-my-order').click(function(){
        monthlyYearlyTable.draw();
    });  
   

   var dailyTable = $('#daily-table').DataTable({ 
        searching: true,
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/daily-report",
          data: function (d) {
                d.status = $('#filter-daily-status').val(),
                d.search = $('.dataTables_filter input').val(),
                d.date_range = $('#daily-date-range').val()
            }
        },

        columns: [
            {data: 'id', name: 'id'},      
            {data: 'customer_name', name: 'customer_name'},
            {data: 'customer_phone', name: 'customer_phone'},
            {data: 'payment_method', name: 'payment_method'},
            {data: 'date', name: 'date'},
            {data: 'status', name: 'status'}, 
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
    

    $('.filter-daily-order').click(function(){
        dailyTable.draw();
    });

    

     var  mycustomReport = $('#my-custom-table').DataTable({ 
        searching: true,
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/my-custom-report",
          data: function (d) {
                d.status = $('#filter-ym-status').val(),
                d.search = $('.dataTables_filter input').val(),
                d.select_section = $('#select-ym-section').val()
            }
        },

        columns: [
            {data: 'id', name: 'id'}, 
            {data: 'customer_name', name: 'customer_name'},
            {data: 'customer_phone', name: 'customer_phone'},
            {data: 'payment_method', name: 'payment_method'},
            {data: 'date', name: 'date'},
            {data: 'status', name: 'status'}, 
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
    

    $('.filter-mycustom-order').click(function(){
         mycustomReport.draw();
    });



    var myDailyTable = $('#my-daily-table').DataTable({ 
        searching: true,
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/my-daily-report",
          data: function (d) {
                d.status = $('#filter-maydaily-status').val(),
                d.search = $('.dataTables_filter input').val(),
                d.date_range = $('#my-daterange').val()
            }
        },

        columns: [

            {data: 'id', name: 'id'},     
            {data: 'customer_name', name: 'customer_name'},
            {data: 'customer_phone', name: 'customer_phone'},
            {data: 'payment_method', name: 'payment_method'},
            {data: 'date', name: 'date'},
            {data: 'status', name: 'status'}, 
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
    

    $('.filter-mydaily-order').click(function(){
        myDailyTable.draw();
    });




    var mymonthlyYearlyReport = $('#my-monthly-yearly-report').DataTable({ 
        processing: true,
        serverSide: true,
        ordering: false,
        stateSave: true,
        ajax: {
          url: base_url+"/my-monthly-yearly-report",
          data: function (d) {
                d.status = $('#filter-ym-status').val(),
                d.search = $('.dataTables_filter input').val(),
                d.select_month = $('#select-ym-month').val(),
                d.select_year = $('#select-ym-year').val()
            }
        },

        columns: [
            {data: 'id', name: 'id'}, 
            {data: 'customer_name', name: 'customer_name'},
            {data: 'customer_phone', name: 'customer_phone'},
            {data: 'payment_method', name: 'payment_method'},
            {data: 'date', name: 'date'},
            {data: 'status', name: 'status'}, 
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
    

    $('.filter-mydaily-order').click(function(){
        mymonthlyYearlyReport.draw();
    });



$(document).on('click', '.delete-promocode', function(e){
      e.preventDefault();
      var int_promocode_id = $(this).data('id');
      ajax_url = base_url+"/promocodes/"+int_promocode_id;
      if(confirm('Do you want to delete this?'))
      {
           $.ajax({

             url: ajax_url,
             type:"DELETE",
             dataType:"json",
             success:function(data) {
                $('.data-table').DataTable().ajax.reload(null, false);
                toastr.success(data);
             },
                    
        });
      }
  });

  
  $(document).on('click', '.delete-slider', function(e){
      e.preventDefault();
      var slider_id = $(this).data('id');
      ajax_url = base_url+"/sliders/"+slider_id;
      if(confirm('Do you want to delete this?'))
      {
           $.ajax({

             url: ajax_url,
             type:"DELETE",
             dataType:"json",
             success:function(data) {
                $('.data-table').DataTable().ajax.reload(null, false);
                toastr.success(data);
             },
                    
        });
      }
  });

  $(document).on('change', '#division_id', function(){
     var division_id = $(this).val();
     ajax_url = base_url+"/get-city/"+division_id;
     $.ajax({

             url: ajax_url,
             type:"GET",
             dataType:"html",
             success:function(data) {
                $('#city_id').html(data);
             },
                    
        });

      getDistricts(base_url,division_id);
  });




$(document).on('change', '#filter-thana-division-id', function(){
     var division_id = $(this).val();
     ajax_url = base_url+"/get-city/"+division_id;
     $.ajax({

             url: ajax_url,
             type:"GET",
             dataType:"html",
             success:function(data) {
                $('#city_id').html(data);
             },
                    
        });

      getDistricts(base_url,division_id);
  });
 



  $(document).on('click', '.decline-user', function(e){ 
     
      e.preventDefault();
      if(confirm('Do you want to decline this vendor?'))
      {
         var vendor_id = $(this).data('id');
         redirect_url = base_url+"/decline-vendor/"+vendor_id;
         window.location.href=redirect_url;
      }
  });
  
  $(document).on('click', '.active-user', function(e){
      e.preventDefault();
      if(confirm('Do you want to active this vendor?'))
      {
          var vendor_id = $(this).data('id');
   
         redirect_url = base_url+"/active-vendor/"+vendor_id;
         window.location.href=redirect_url;
      }

      
  });

  $(document).on('click', '.delete-vendor', function(e){
     e.preventDefault();
     if(confirm('Do you want to delete this vendor?'))
     {
        var get_vendor_id = $(this).data('id');

        ajax_url = base_url+"/users/"+get_vendor_id;
        $.ajax({

             url: ajax_url,
             type:"DELETE",
             dataType:"json",
             success:function(data) {
                toastr.success(data);

                 $('.data-table').DataTable().ajax.reload(null, false);
 
             },
                    
        });
     }

  });

  $(document).on('click', '.delete-district', function(e){
    if(confirm('Do you want to delete this district?'))
     {
        var int_district_id = $(this).data('id');

        ajax_url = base_url+"/districts/"+int_district_id;
        $.ajax({

             url: ajax_url,
             type:"DELETE",
             dataType:"json",
             success:function(data) {
                toastr.success(data);

                 $('.data-table').DataTable().ajax.reload(null, false);
 
             },
                    
        });
     }    
  });

  $(document).on('click', '.delete-division', function(e){
     e.preventDefault();
     if(confirm('Do you want to delete this division?'))
     {
        var int_division_id = $(this).data('id');

        ajax_url = base_url+"/divisions/"+int_division_id;
        $.ajax({

             url: ajax_url,
             type:"DELETE",
             dataType:"json",
             success:function(data) {
                toastr.success(data);

                 $('.data-table').DataTable().ajax.reload(null, false);
 
             },
                    
        });
     }

  });


  $(document).on('click', '.delete-division', function(e){
     e.preventDefault();
     if(confirm('Do you want to delete this division?'))
     {
        var int_division_id = $(this).data('id');

        ajax_url = base_url+"/divisions/"+int_division_id;
        $.ajax({

             url: ajax_url,
             type:"DELETE",
             dataType:"json",
             success:function(data) {
                toastr.success(data);

                 $('.data-table').DataTable().ajax.reload(null, false);
 
             },
                    
        });
     }

  });

  $(document).on('click', '.delete-vehicleType', function(e){
     e.preventDefault();
     var int_type_id = $(this).data('id');

     if(confirm('Do you want to delete this?'))
     {
        var int_type_id = $(this).data('id');

        ajax_url = base_url+"/vehicle-types/"+int_type_id;
        $.ajax({

             url: ajax_url,
             type:"DELETE",
             dataType:"json",
             success:function(data) {
                toastr.success(data);

                 $('.data-table').DataTable().ajax.reload(null, false);
 
             },
                    
        });
     }

  });


  $(document).on('click', '.delete-brand', function(e){
     e.preventDefault();
     var int_brand_id = $(this).data('id');

     if(confirm('Do you want to delete this?'))
     {
        var int_brand_id = $(this).data('id');

        ajax_url = base_url+"/brands/"+int_brand_id;
        $.ajax({

             url: ajax_url,
             type:"DELETE",
             dataType:"json",
             success:function(data) {
                toastr.success(data);

                 $('.data-table').DataTable().ajax.reload(null, false);
 
             },
                    
        });
     }

  });

  $(document).on('click', '.delete-thana', function(e){
     e.preventDefault();
     if(confirm('Do you want to delete this thana?'))
     {
        var int_thana_id = $(this).data('id');

        ajax_url = base_url+"/thanas/"+int_thana_id;
        $.ajax({

             url: ajax_url,
             type:"DELETE",
             dataType:"json",
             success:function(data) {
                toastr.success(data);

                 $('.data-table').DataTable().ajax.reload(null, false);
 
             },
                    
        });
     }

  });


  $(document).on('click', '.search-thana', function(e){
     e.preventDefault();
     var get_division_id = $('#division_id').val();
     var get_district_id = $('#district_id').val();
     ajax_url = base_url+"/get-thanas";
     $.ajax({

             url: ajax_url,
             type:"GET",
             data:{'division_id':get_division_id, 'district_id':get_district_id},
             dataType:"html",
             success:function(data) {
                $('#get-thanas').html(data);
                //console.log(data);
             },
                    
        });
  });


$('#reservationdatetime').datetimepicker({ icons: { time: 'far fa-clock' } });
 

 $(document).on('click', '.show-report', function(e){
    e.preventDefault();
    $('.modal').modal('show');
    var order_id = $(this).data('id');
    ajax_url = base_url+"/get-order/"+order_id;
    $.ajax({

             url: ajax_url,
             type:"GET",
             dataType:"json",
             success:function(data) {
              $('.sender-name').text(data.sender_name);
              $('.sender-address').text(data.sender_address);
              $('.sender-phone').text(data.sender_phone);
              $('.receiver-name').text(data.receiver_name);
              $('.full_address').text(data.full_address);
              $('.receiver-phone').text(data.receiver_phone);
              $('.item-type').text(data.item_type);
              $('.item-weight').text(data.weight);
              $('.total').text(data.total_price);
              $('.deliverymen').text(data.deliver_name);
                console.log(data);
                //console.log(data);
             },
                    
        });
 });

 $(document).on('click', '.close-modal', function(e){
    e.preventDefault();
    $('.modal').modal('hide');
 });
 
 
 $(document).on('change', '.update-change-stataus', function(){
    var status_id = $(this).data('id');
    var get_req_status = $(this).val();

    if(confirm('Do you want to change the status?'))
    {
        ajax_url = base_url+"/update-change-status/"+status_id;
       $.ajax({

               url: ajax_url,
               type:"GET",
               data:{'status':get_req_status},
               dataType:"json",
               success:function(data) {
                  $('.data-table').DataTable().ajax.reload(null, false);
                  toastr.success(data);
                  //console.log(data);
               },
                      
          });
    }
 });

  $(document).on('click', '.decline-option', function(e){
   e.preventDefault();
   var payment_id = $(this).data('id');
   if(confirm('Do you want to change the status?'))
    {
        ajax_url = base_url+"/payment-decline/"+payment_id;
       $.ajax({

               url: ajax_url,
               type:"GET",
               dataType:"json",
               success:function(data) {
                  $('.data-table').DataTable().ajax.reload(null, false);
                  toastr.success(data);
               },
                      
          });
    }
 });


  $(document).on('click', '.active-option', function(e){
   e.preventDefault();
   var payment_id = $(this).data('id');
   if(confirm('Do you want to change the status?'))
    {
        ajax_url = base_url+"/payment-active/"+payment_id;
       $.ajax({

               url: ajax_url,
               type:"GET",
               dataType:"json",
               success:function(data) {
                  $('.data-table').DataTable().ajax.reload(null, false);
                  toastr.success(data);
               },
                      
          });
    }
 });

  $(document).on('click', '.edit-option', function(e){
     e.preventDefault();
     var int_payment_id = $(this).data('id');
     $('.get_payment_id').val(int_payment_id);
     $('#payment-modal').modal('show');
     ajax_url = base_url+"/payment-show/"+int_payment_id;
       $.ajax({

               url: ajax_url,
               type:"GET",
               dataType:"json",
               success:function(data) {
                  $('#name').val(data.name);
                  $('.api_key').val(data.api_key);
                  $('.api_secret').val(data.api_secret);
               },
                      
          });

  });

  $(document).on('click', '.update-paymentmethod', function(e){
    e.preventDefault();
    var name = $('#name').val();
    var get_payment_id = $('.get_payment_id').val();
    var api_key = $('.api_key').val();
    var api_secret = $('.api_secret').val();
    ajax_url = base_url+"/payment-info-update";
       $.ajax({

               url: ajax_url,
               type:"GET",
               data:{'payment_id':get_payment_id, 'name':name, 'api_key':api_key, 'api_secret':api_secret},
               dataType:"json",
               success:function(data) {
                  $('.data-table').DataTable().ajax.reload(null, false);
                  toastr.success(data);
                  $('#payment-modal').modal('hide');
               },
                      
          });

  });

  $(document).on('click', '.delete-notification', function(e){
     e.preventDefault();
     var inbox_id = $(this).data('id');
      ajax_url = base_url+"/inboxes/"+inbox_id;
        if(confirm('Do you want to delete this?'))
        {
             $.ajax({

               url: ajax_url,
               type:"DELETE",
               dataType:"json",
               success:function(data) {
                  $('.data-table').DataTable().ajax.reload(null, false);
                  toastr.success(data);
               },
                      
          });
        }
  });

  $(document).on('click', '.decline-withdraw', function(e){
      e.preventDefault();
      var int_withdraw_id = $(this).data('id');
      if(confirm('Do you want to change the status?'))
      {
          ajax_url = base_url+"/decline-withdraw/"+int_withdraw_id; 
         $.ajax({

                 url: ajax_url,
                 type:"GET",
                 dataType:"json",
                 success:function(data) {
                    $('.data-table').DataTable().ajax.reload(null, false);
                    toastr.success(data);
                 },
                        
            });
      }
  });


  $(document).on('click', '.active-withdraw', function(e){
      e.preventDefault();
      var int_withdraw_id = $(this).data('id');
      var int_withdraw_id = $(this).data('id');
      if(confirm('Do you want to change the status?'))
      {
          ajax_url = base_url+"/active-withdraw/"+int_withdraw_id;
         $.ajax({

                 url: ajax_url,
                 type:"GET",
                 dataType:"json",
                 success:function(data) {
                    $('.data-table').DataTable().ajax.reload(null, false);
                    toastr.success(data);
                 },
                        
            });
      }
  });


});


function getDistricts(base_url,division_id)
{
     ajax_url = base_url+"/get-district/"+division_id;
     $.ajax({

             url: ajax_url,
             type:"GET",
             dataType:"html",
             success:function(data) {
                $('#district_id').html(data);
                $('#filter-thana-district-id').html(data);
             },
                    
        });
}


function readURL(input) {
      if (input.files && input.files[0]) {
          var reader = new FileReader();
          reader.onload = function (e) {
              $('.preview-image')
                  .attr('src', e.target.result)
                  .width(80)
                  .height(80);

              $('.preview-image-update')
                  .attr('src', e.target.result)
                  .width(80)
                  .height(80);

          };
          reader.readAsDataURL(input.files[0]); 
      }
   }

   function readURL1(input) {
      if (input.files && input.files[0]) {
          var reader = new FileReader();
          reader.onload = function (e) {
              $('.preview-image-two')
                  .attr('src', e.target.result)
                  .width(80)
                  .height(80);


                  $('.preview-image-two-update')
                  .attr('src', e.target.result)
                  .width(80)
                  .height(80);
          };
          reader.readAsDataURL(input.files[0]); 
      }
   }
