@extends('admin_master')
@section('content')
 <div class="content-wrapper">
   <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Edit District</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{URL::to('/dashboard')}}">Dashboard</a></li>
              <li class="breadcrumb-item active">Edit District</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <section class="content">
    	<div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Update Division</h3>
              </div>
              <!-- /.card-header -->
              <!-- form start -->
              <form action="{{route('districts.update',$district->id)}}" method="POST" enctype="multipart/form-data">
              	@csrf
                @method('PATCH')
                <div class="card-body">

                <div class="form-group">
                  <label for="name">District Name <span class="required">*</span></label>
                  <input type="text" name="name" class="form-control" id="name" placeholder="District Name" value="{{old('name',$district->name)}}" required="">
                  @error('name')
		                 <span class="alert alert-danger">{{ $message }}</span>
                  @enderror
                     
                </div>

                <div class="form-group">
                  <label for="division_id">Select Division <span class="required">*</span></label>
                  <select class="form-control select2bs4" name="division_id" id="division_id" required="">
                      <option value="" selected="" disabled="">Select Division</option>
                      @foreach(divisions() as $division)
                      <option value="{{$division->id}}" <?php if($division->id == $district->division_id){echo "selected";} ?>>{{$division->name}}</option>
                      @endforeach
                  </select>
                  @error('division_id')
                     <span class="alert alert-danger">{{ $message }}</span>
                  @enderror
                </div>

                <div class="form-group">
                  <button type="submit" class="btn btn-success">Update</button>
                </div>

                </div>

                  
                </div>
                <!-- /.card-body -->

                
              </form>
            </div>
    </section>
 </div>
@endsection