@extends('admin_master')
@section('content')
 <div class="content-wrapper">
   <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Edit Notification</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{URL::to('/dashboard')}}">Dashboard</a></li>
              <li class="breadcrumb-item active">Edit Notification</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <section class="content">
    	<div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Update Notification</h3>
              </div>
              <!-- /.card-header -->
              <!-- form start -->
              <form action="{{route('inboxes.update',$inbox->id)}}" method="POST" enctype="multipart/form-data">
              	@csrf
                @method('PATCH')
                <div class="card-body">

                <div class="form-group">
                  <label for="title">Title <span class="required">*</span></label>
                  <input type="text" name="title" class="form-control" id="title" placeholder="Title" value="{{old('title',$inbox->title)}}" required="">

                  @error('title')
                     <span class="alert alert-danger">{{ $message }}</span>
                  @enderror

                </div>


                <div class="form-group">
                  <label for="type">Select Type <span class="required">*</span></label>
                  <select class="form-control select2bs4" name="type" id="type" required="">
                  	<option value="" selected="" disabled="">Select Type</option>
                  	<option value="inbox" <?php if($inbox->type == 'inbox'){echo "selected";} ?>>Inbox</option>
                  	<option value="notification" <?php if($inbox->type == 'notification'){echo "selected";} ?>>Notification</option>
                  </select>

                  @error('type')
                     <span class="alert alert-danger">{{ $message }}</span>
                  @enderror
                </div>

                <div class="form-group">
                  <label for="description">Description <span class="required">*</span></label>
                  <textarea id="summernote" name="description" required="">{{old('description',$inbox->description)}}</textarea>

                  @error('description')
                     <span class="alert alert-danger">{{ $message }}</span>
                  @enderror
                </div>

                  
          
                <div class="form-group">
                   <label for="image">Image</label>
                   <input name="image" type="file" id="image" class="dropify" accept="image/*" data-height="200" data-default-file="{{URL::to($inbox->image)}}" />

                 </div> 

                  
                </div>
                <!-- /.card-body -->

                <div class="card-footer">
                  <button type="submit" class="btn btn-success">Update</button>
                </div>
              </form>
            </div>
    </section>
 </div>
@endsection