@extends('admin_master')
@section('content')
 <div class="content-wrapper">
   <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Update Vehicle Type</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{URL::to('/dashboard')}}">Dashboard</a></li>
              <li class="breadcrumb-item active">Edit Vehicle Type</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <section class="content">
    	<div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Edit Vehicle Type</h3>
              </div>
              <!-- /.card-header -->
              <!-- form start -->
              <form action="{{route('vehicle-types.update',$vehicleType->id)}}" method="POST" enctype="multipart/form-data">
              	@csrf
                @method('PATCH')
                <div class="card-body">

                <div class="form-group">
                  <label for="type">Type <span class="required">*</span></label>
                  <input type="text" name="type" class="form-control" id="type" placeholder="Vehicle Type" value="{{old('type',$vehicleType->type)}}" required="">
                  @error('type')
		                 <span class="alert alert-danger">{{ $message }}</span>
                  @enderror
                     
                </div>

                <div class="form-group">
                  <button type="submit" class="btn btn-success">Update</button>
                </div>

                </div>

                  
                </div>
                <!-- /.card-body -->

                
              </form>
            </div>
    </section>
 </div>
@endsection